/*
   Phil's C Course - http://www.pottsoft.demon.co.uk/c_course/course.html

   Example 8          Phil Ottewell 1998 <phil@pottsoft.demon.co.uk>

   Purpose:
            File i/o again, and expression parsing
*/
/*---- Calculator expression evaluator example ("calc.c") --------------------*/
/*
	History:
	Version		Name                    Date
	V01-001		Neill Clift             16-Mar-1995
			Initial version
*/

/* ANSI Headers */
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

/* Function prototypes */
int parse_expression(void);
int parse_expression_factor(void);
int parse_expression_term(void);
int parse_literal(void);
int getnonwhite(void);
int match_token(int tomatch);

/* Start of main program */
int main( int argc, char *argv[])
{
  int val;
/*  End of declarations ... */

  printf("Enter expression terminated by ;\n");
  printf("Calc> ");
  val = parse_expression();
  if (match_token(';')) {
    printf("Result is %d\n",val);
  } else {
    printf("Expression seems bust\n");
  }
  exit(EXIT_SUCCESS);
}

/*---- Get the next character skipping white space ---------------------------*/
int getnonwhite(void)
{
    int c;
/*  End of declarations ... */

    while (1) {
      c = getchar();
      if (c == EOF) {
        break;
      } else if (!isspace(c)) {
        break;
      }
    }
    return( c );
}

/*--- Match single character against next input char. If match then gobble ---*/
/*--- it up. If we don't match it then push it back for future matches -------*/
int match_token(int tomatch)
{
    int c;
/*  End of declarations ... */

    c = getnonwhite();
    if (c == tomatch) {
      return( 1 );
    } else {
      ungetc(c,stdin); /* Put character back on input stream to be read again */
      return( 0 );
    }
}

/*---- Parse a single number from input +/- nnnnn  ---------------------------*/
int parse_literal(void)
{
    int retval,st;
/*  End of declarations ... */

    retval = 0;

    st = scanf("%d",&retval);
    if (st == EOF) {
      printf("Hit EOF looking for literal\n");
    } else if (st == 0) {
      printf("Missing literal\n");
    }

    return( retval );
}

/*---- Syntax is:   Literal    or:   (expression)  ---------------------------*/
int parse_expression_factor(void)
{
  int retval;
/*  End of declarations ... */

  if (match_token('(')) {
    retval = parse_expression();
    if (!match_token(')'))
      printf("Missing close bracket\n");
  } else {
    retval = parse_literal();
  }

  return( retval );
}


/*---- Parse an expression term,  Syntax: <factor>{<multiplying_op><factor>} -*/
int parse_expression_term(void)
{
  int tmp,mul,opr;
/*  End of declarations ... */

  tmp = parse_expression_factor();

  while (1) {
    if (match_token('*')) {
      opr = 1;
    } else if (match_token('/')) {
      opr = -1;
    } else {
      break;
    }

    mul = parse_expression_factor();
    if (opr == 1) {
      tmp = tmp * mul;
    } else if (mul == 0) {
      printf("Division by zero!\n");
    } else {
      tmp = tmp / mul;
    }
  }
  return( tmp );
}

/*---- Parse an expression, Syntax: [+/-]<term>{<adding_op><term>} -----------*/
int parse_expression(void)
{
  int tmp,mul,add;
/*  End of declarations ... */

  /* Check for leading + or -. None means plus */

  if (match_token('+')) {
    mul = 1;
  } else if (match_token('-')) {
    mul = -1;
  } else {
    mul = 1;
  }

  tmp = parse_expression_term();
  tmp = tmp * mul;

  while (1) {
    if (match_token('+')) {
      mul = 1;
    } else if (match_token('-')) {
      mul = -1;
    } else {
      break;
    }
    add = parse_expression_term();
    tmp = tmp + mul * add;
  };

  return( tmp );
}
