/*
   Phil's C Course - http://www.pottsoft.demon.co.uk/c_course/course.html

   Supplementary Example  Phil Ottewell 1998 <phil@pottsoft.demon.co.uk>

   Purpose:
            
*/
/*---- C Example to "look up" a function by name ("functable.c") ------------*/

/* ANSI C Headers */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Defines and macros */
#define SIG_LEN 3
/* #define I_WANT_A_COMPILATION_WARNING */  /* Uncommant if you do ! */

/* Function prototypes */
int add_ints( int first, int second ); /* returns first + second */
int sub_ints( int first, int second ); /* returns first - second */
int neg_ints( int only ); /* Negate - only has one argument */

/* Typedefs */
typedef int (*func_ptr_t)( int first, int second );

/* Structures */
struct func_table_s {
  func_ptr_t fptr;
  char *name;
};


/* Main Program starts here */
int main( int argc, char *argv[] )
{
    int i;
    int result;
    int got_match;
    char answer[8];
    struct func_table_s ftable[] = { {add_ints,"Add"},   /* Set up table of */
                                     {sub_ints,"Sub"},   /* named functions */
#ifdef I_WANT_A_COMPILATION_WARNING
                                     {neg_ints,"Neg"},
#endif
                                     {NULL,NULL}      };
/*  End of declarations ... */

    printf("Function name to call with args 6 and 3 (Add/Sub): ");
    fgets( answer, sizeof(answer) , stdin);

    i = 0;
    got_match = 0;
    while ( ftable[i].fptr ) {
/*    Check name againt each function in table */
/*    Remember that strncmp returns 0 for a match ! */
      if ( !strncmp(answer,ftable[i].name,SIG_LEN) ) {
        got_match = 1;
/*      Call appropriate function through the pointer */
        result = (*ftable[i].fptr)( 6, 3 );
        break;
      }
      ++i;
    }

    if ( got_match ) {
      printf( "Called \"%s\" - Result was %d\n", ftable[i].name, result );
    } else {
      printf( "Couldnt match name - %s\n", answer);
    }

    exit(EXIT_SUCCESS);
}

/*---- Rather pathetic function to add up some integers ----------------------*/
int add_ints( int first, int second )
{
/*  End of declarations ... */
    return( first + second );
}

/*---- Crap function to subtract some integers ------------------------------*/
int sub_ints( int first, int second )
{
/*  End of declarations ... */
    return( first - second );
}

/*---- Worse function to negate integers -------------------------------------*/
int neg_ints( int only )
{
/*  End of declarations ... */
    return( -only );
}
/*----------------------------------------------------------------------------*/
