/*
   Phil's C Course - http://www.pottsoft.demon.co.uk/c_course/course.html

   Example 13         Phil Ottewell 1998 <phil@pottsoft.demon.co.uk>

   Purpose:
            Demonstrate signal trapping and setjmp/longjmp
*/
/*---- Signal and longjmp Example ("signal.c") -------------------------------*/

/* ANSI C Headers */
#include <setjmp.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>

#if defined( _WIN32 )
# include "windows.h"
#endif

/* Defines and macros */
#define MAX_COUNT 5

/* Global variables */
jmp_buf saved_position;

/* Function prototypes */
void ctrl_c_handler( int scode );

/* Main Program starts here */
int main( int argc, char *argv[] )
{
    int icount;
/*  End of declarations ... */

    icount = 0;

    signal( SIGINT, ctrl_c_handler );

    if ( !setjmp(saved_position) ) {
      for ( ; icount < MAX_COUNT; ++icount ) {
        printf("At main line - looping #%d - enter Ctrl/C\n", icount);
#if !defined( _WIN32 )
        sleep( 10 );
#else
        Sleep( 10000 );
#endif
      };
    } else {
      printf("Returned from Ctrl C handler - exiting early\n");
    }

    exit(EXIT_SUCCESS);
}

void ctrl_c_handler( int scode )
{
/*  End of declarations ... */

    if ( scode == SIGINT ) {
      printf("Handling Ctrl C - return to position saved by setjmp()\n");
      longjmp( saved_position, 1 ); /* Use any non-zero number */
    } else {
      printf("Strange - Ctrl C handler called with wrong signal code !\n");
    }
}
